#Author: pmehta
###############################    DATA    ####################################
library(xxm) 
data(mlcfa.xxm, package="xxm")
head(student)
head(teacher)
ys1  <- c("LCE", "PCE","PVE", "VAE") 
latents1 <- c("student_reading") 
latents2 <- c("rLCE", "rPCE","rPVE", "rVAE", "teacher_reading") 
################################################################## 
################################################################## 
########################## STUDENT MODEL MATRICES ################
#Student: factor-covariance matrix: Starting values
ly1_pat <- matrix(1,4,1)
ly1_val <- matrix(.1,4,1)

#Student: factor-covariance matrix: Pattern of free parameters
ps1_pat <- matrix(0,1,1)
ps1_val <- matrix(1,1,1)

#Student: factor-covariance matrix: Starting values
th1_pat <- diag(1, 4, 4) 
th1_val <- diag(2, 4, 4) 

#Student "grand-means" NU
nu1_pat <- matrix(1,4,1)
nu1_val <- matrix(c(46.064, 47.058, 46.480, 48.001),4,1)
################################################################## 
################################################################## 
###################### teacher model matrices ############
#Teacher:factor-loading matrix: Pattern of free parameters
ps2_pat <- diag(c(0,0,0,0, 1),5,5)
ps2_val <- diag(c(1,1,1,1, .1),5,5)
################################################################## 
###################### teacher-?student link matrices ############

ly12_pat <- matrix(
			  c(1,0,0,0,0,
				0,1,0,0,1,
				0,0,1,0,1,
				0,0,0,1,1), 4,5,byrow=TRUE)
ly12_val <- matrix(
		      c(.01,0,0,0, 1,
				0,.01,0,0, 1,
				0,0,.01,0, 1,
				0,0,0,.01, 1), 4,5,byrow=TRUE)

#	Actual Script
levels <- c("student","teacher")
xm <- xxmModel(levels)
xm <- xxmSubmodel(model = xm,
		level = "student", 
		parents = "teacher",
		ys = ys1,
		xs=,
		etas = latents1,
		data = mlcfa.student)
xm <- xxmSubmodel(model = xm,
		level = "teacher",
		,,,
		etas = latents2,
		data = mlcfa.teacher) 
##################################################################
#l1 within matrices (lambda, psi, theta and nu) 
xm <- xxmWithinMatrix(xm,"student","lambda", ly1_pat, ly1_val,,)
xm <- xxmWithinMatrix(xm,"student","psi", ps1_pat, ps1_val,,)
xm <- xxmWithinMatrix(xm,"student","theta", th1_pat, th1_val,,)
xm <- xxmWithinMatrix(xm,"student","nu", nu1_pat, nu1_val,,) 
#l2 within matrices (psi)
xm <- xxmWithinMatrix(xm,"teacher","psi", ps2_pat, ps2_val,,)  
##l2->l1 lambda matrix 
xm <- xxmBetweenMatrix(xm,"teacher","student","lambda", ly12_pat, ly12_val,,)
xm <-xxmRun(xm) 
xm <-xxmCI(xm) 
est <- xxmGet(xm, "estimates")
fit  <- xxmGet(xm, "fit")
xxmFree(xm) 
rm(list=ls())
detach("package:xxm", unload=TRUE)
